/*
 * Decompiled with CFR 0.152.
 */
package com.category.controller;

import com.Application;
import com.category.domain.ProductCategoryService;
import com.utility.ConvertStr;
import com.utility.TextNormalizer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
public class ProductCategoryAPI {
    private final Application application;
    private final ProductCategoryService pCategoryService;

    @GetMapping(value={"/Poshak"})
    public ResponseEntity<?> getPoshak(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return ConvertStr.getMapResponseEntity((String)"poshak", (List)this.pCategoryService.getProductCategories(request), (boolean)TextNormalizer.isFarsi((HttpServletRequest)request));
    }

    @ApiIgnore
    @PostMapping(value={"/PoshakZ"})
    public ResponseEntity<?> postPoshakZ(@RequestBody byte[] zippedBody) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.pCategoryService.postSmartHelpProductCategories(zippedBody);
    }

    public ProductCategoryAPI(Application application, ProductCategoryService pCategoryService) {
        this.application = application;
        this.pCategoryService = pCategoryService;
    }
}

